# --------------------------------------------------------
# modified from hora

import hydra

from omegaconf import DictConfig, OmegaConf
from hora.utils.misc import set_np_formatting, set_seed


try:
    OmegaConf.register_new_resolver('eq', lambda x, y: x.lower() == y.lower())
except:
    pass
try:
    OmegaConf.register_new_resolver('contains', lambda x, y: x.lower() in y.lower())
except:
    pass
try:
    OmegaConf.register_new_resolver('if', lambda pred, a, b: a if pred else b)
except:
    pass

try:
    OmegaConf.register_new_resolver('resolve_default', lambda default, arg: default if arg == '' else arg)
except:
    pass


@hydra.main(config_name='config', config_path='configs')
def main(config: DictConfig):
    set_np_formatting()
    config.seed = set_seed(config.seed)

    if config.deploy_type == 'invdyn':
        from hora.algo.deploy.deploy_leap import HardwarePlayerInvdynV1
        agent = HardwarePlayerInvdynV1(config)
    else:
        raise NotImplementedError(f"Deploy type {config.deploy_type} is not implemented")
    

    agent.deploy()


if __name__ == '__main__':
    main()
